// LAB:8 Perform DFT and IDFT of discrete signal.
// Version : Scilab 5.4.1
// Operating System : Window-xp, Window-7


clc;
close;
clear;
x=[1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0]; // Step Sequence
N=length(x); // Number of Point DFT
for k=1:2*N
    y(k)=0;
    for n=1:N
        y(k)=y(k)+(x(n)*exp((-2*%pi*(k-1)*(n-1)*%i)/N));
    end
end
subplot(311);
plot2d3(x);
title('Step Sequence','color','Red','fontsize',3);
xlabel('Time Index');
ylabel('Amplitude');

subplot(312);
plot2d3(abs(y));
title('DFT','color','Red','fontsize',3);
xlabel('Frequency Scale');
ylabel('Amplitude');

/////////////// IDFT ////////////////
for n=1:N
p(n)=0;
for  k=1:N
p(n)=p(n)+((y(k)*exp((%i*2*%pi*(k-1)*(n-1))/N))/N);
end
end
subplot(313);
plot2d3(abs(p));
title('IDFT','color','Red','fontsize',3);
xlabel('Time Index');
ylabel('Amplitude');
